/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler.validate;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.config.ServerConfig;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PolicyManager {
    private static final Set<Class<?>> policyClasses = new LinkedHashSet();

    private PolicyManager() {
    }

    public static void reloadPolicyClasses(Set<String> classNames) {
        policyClasses.clear();
        for (String className : classNames) {
            try {
                policyClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                if (!ClientSort.debug()) continue;
                ClientSort.LOG.warn("Unable to load policy class '{}': Class not found.", className);
            }
        }
    }

    public static void setPolicy(ServerClassPolicy classPolicy) {
        ServerClassPolicy existingPolicy = ServerConfig.serverOptions().classPolicies.get(classPolicy.className);
        if (existingPolicy != null) {
            existingPolicy.setFrom(classPolicy);
            ClientSort.LOG.info("Updated the class policy for '{}' due to operation failure", classPolicy.className);
        } else {
            ServerConfig.serverOptions().classPolicies.put(classPolicy.className, classPolicy);
            ClientSort.LOG.info("Added a new class policy for '{}' due to operation failure", classPolicy.className);
        }
        ServerConfig.save();
    }

    public static void checkPolicy(Class<?> cls, Function<ServerClassPolicy, Boolean> op) throws PayloadHandlerException {
        ServerClassPolicy configClassPolicy = PolicyManager.getClassPolicy(cls);
        if (configClassPolicy != null && !op.apply(configClassPolicy).booleanValue()) {
            throw new PayloadHandlerException(String.format("Server policy does not allow this operation for class '%s'!", cls.getName()));
        }
    }

    private static ServerClassPolicy getClassPolicy(Class<?> cls) {
        ServerClassPolicy layout = ServerConfig.serverOptions().classPolicies.get(cls.getName());
        if (layout != null) {
            return layout;
        }
        Set matches = policyClasses.stream().filter(c -> c.isAssignableFrom(cls)).collect(Collectors.toSet());
        for (Class c1 : matches) {
            boolean hasSubclass = false;
            for (Class c2 : matches) {
                if (c1.equals(c2) || !c1.isAssignableFrom(c2)) continue;
                hasSubclass = true;
                break;
            }
            if (hasSubclass) continue;
            return ServerConfig.serverOptions().classPolicies.get(c1.getName());
        }
        return null;
    }
}

